/**********************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***********************************************************************************************
$Id:  $:

Description:
**************************************************************************************/
#ifndef DRV_ETH_IP_PUBLIC_H_
#define DRV_ETH_IP_PUBLIC_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include "DrvEth_Public.h"

/*##################################################################*/

/* Helper structures for IP layer */

/* Ethernet protocol numbers */
#define DRV_ETH_FRAME_ICMP_PROTO 0x01
#define DRV_ETH_FRAME_IGMP_PROTO 0x02
#define DRV_ETH_FRAME_TCP_PROTO  0x06
#define DRV_ETH_FRAME_UDP_PROTO  0x11

/*##################################################################*/
/* IP HEADER */
/*##################################################################*/

typedef __PACKED_PRE struct DRV_ETH_IP_HEADER_Ttag
{
  __PACKED_PRE union
  {
    __PACKED_PRE struct
    {
      uint8_t  bHeaderLen : 4;
      uint8_t  bVersion   : 4;

    } __PACKED_POST tBit;

    uint8_t bVersionHeaderLen;

  } __PACKED_POST uVerHeadLen;

  uint8_t   bTos;
  uint16_t  usLength;
  uint16_t  usIdentifier;

  __PACKED_PRE union
  {
    __PACKED_PRE struct
    {
      uint16_t  bFragmentOffset : 13;
      uint16_t  bFlags          : 3;

    } __PACKED_POST tBit;

    uint16_t usFlagsFragmentOffset;

  } __PACKED_POST uFlagsFrag;

  uint8_t   bTtl;
  uint8_t   bProtocol;
  uint16_t  usChecksum;
  uint32_t  ulAddrSrc;
  uint32_t  ulAddrDst;

} __PACKED_POST DRV_ETH_IP_HEADER_T;


/*##################################################################*/
/* UDP HEADER */
/*##################################################################*/

typedef __PACKED_PRE struct DRV_ETH_UDP_HEADER_Ttag
{
  uint16_t  usSrcPort;
  uint16_t  usDstPort;
  uint16_t  usLength;
  uint16_t  usChecksum;

} __PACKED_POST DRV_ETH_UDP_HEADER_T;

/*##################################################################*/

#ifdef __cplusplus
}
#endif

#endif /* DRV_ETH_IP_PUBLIC_H_ */
